/*
* Includes
*/
#include <stdlib.h>
#include <stdio.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include "adelay.h"
#include "lcd.h"

/* 
*  Define the buttons, no need to switch to input as they're all inputs by default
*  DDRX = I/O settings,
*  PORTx = Turn on/off internal pull up resistors
*  PINx = Input register
*/

#define BUTTON_PORT PORTB      			 /* PORTx - register for button output */
#define BUTTON_PIN  PINB

#define BTN_SHOOT_PIN 		PINC         /* PINx - register for button input */
#define BTN_SHOOT_BIT  		PC3          /* bit for button input/output */

#define BTN_LEFT_PIN 		PINB         /* PINx - register for button input */
#define BTN_LEFT_BIT 		PB1          /* bit for button input/output */
#define BTN_RIGHT_PIN		PINB         /* PINx - register for button input */
#define BTN_RIGHT_BIT		PB2          /* bit for button input/output */
#define BTN_UP_PIN 			PINB         /* PINx - register for button input */
#define BTN_UP_BIT 			PB3          /* bit for button input/output */
#define BTN_DOWN_PIN 		PINB         /* PINx - register for button input */
#define BTN_DOWN_BIT 		PB4          /* bit for button input/output */
#define BTN_MODE_PIN 		PINB         /* PINx - register for button input */
#define BTN_MODE_BIT 		PB5          /* bit for button input/output */

#define OUTPUT_PORT PORTD
#define IROUT_BIT PD7

//PortD Output
/****************************************/
/****************************************/
/****** Variable Definitions     ********/
/****************************************/
/****************************************/
uint8_t count=0;	//count loop timer for shoot function

//io init
void init_io(void)
{
	//All Ouputs on
	DDRD = 0xff;
	DDRC |= ( 1 << PC1);
	DDRC |= ( 1 << PC2);
	
	//Turn on pullups
	PORTB |= (1 << BTN_LEFT_BIT);
	PORTB |= (1 << BTN_UP_BIT);
	PORTB |= (1 << BTN_DOWN_BIT);
	PORTB |= (1 << BTN_RIGHT_BIT);
	PORTB |= (1 << BTN_MODE_BIT);
	
	PORTC |= (1 << BTN_SHOOT_BIT);
}

void shoot(void)
{
		for(count=0; count <=16; count++)
		{
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(15.625);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		Delay_us(15.625);
		}
		
		Delay_us(7300);
		
		for(count=0; count <=16; count++)
		{
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn on
		Delay_us(15.625);
		OUTPUT_PORT ^= (1 << IROUT_BIT); //turn off
		Delay_us(15.625);
		}
}

int is_button_pressed(void)
{
	//we debounce all of port B and the single bit of port C
	//save the state of BUTTON_PIN to an 8 bit integer
	
	if (bit_is_clear(PINC, PC3))
	{
		Delay_ms(30);
		if (bit_is_clear(PINC, PC3))
			return 1;
	}
	
	return 0;
}

int main(void)
{
	init_io();
	OUTPUT_PORT &= ~(1 << IROUT_BIT);
	while(1)
	{
		if(is_button_pressed() == 1)
		{
		PORTC |= (1 << PC1);
		PORTC &= ~(1 << PC2);
		
		shoot();
		}
		else
		{
		PORTC &= ~(1 << PC1);
		PORTC |= (1 << PC2);
		}
	}
	return 1;
}
